#!/bin/sh

set -e

failure() { echo "$1";  exit 1; }

fwinfo() {
	awk "/$1/ { print \$2 }" /etc/fw-info | tr -d '",'
}

if [ -f /etc/fw-info ]; then
	plat=$(fwinfo platform)
	inst_type=$(fwinfo install_type)

	if [ -n "$plat" ] && [ "$plat" != "cv" ]; then
		failure "Wrong firmware update file, target platform is cv"
	fi

	if [ -n "$inst_type" ] && [ "$inst_type" != "nand" ]; then
		failure "Wrong firmware update file, target installation type is nand"
	fi
fi

if [ -f fw.md5 ]; then
	echo "Verifying md5 checksums"
	md5sum -s -c fw.md5 > /dev/null 2>&1
fi

if [ ! -d /nvdata/anthillos ]; then
	echo "AnthillOS not installed!"
	exit 1
fi

if [ -d scripts ]; then
	echo "Updating scripts"
	cp -R -f scripts /nvdata/anthillos > /dev/null 2>&1
	chmod 4755 /nvdata/anthillos/scripts/boot
	chmod 755 /nvdata/anthillos/scripts/bootos.sh
	chmod 755 /nvdata/anthillos/scripts/updateos.sh
fi

if [ -e overlay.tar.gz ]; then
	echo "Updating overlay.tar.gz"
	cp -f overlay.tar.gz /nvdata/anthillos > /dev/null 2>&1
fi

mkdir -p /tmp/stock-config
if mount -t ext4 -o sync /dev/mmcblk0p5 /tmp/stock-config; then
	if [ -e /tmp/stock-config/sn ]; then
		cp /tmp/stock-config/sn /config/serial
	fi
	umount /tmp/stock-config
fi

sync

if [ -f /nvdata/anthillos/scripts/updateos.sh ]; then
	nohup /nvdata/anthillos/scripts/updateos.sh > /dev/null 2>&1 &
fi